# Click

This example shows how to implement click interraction with nodes and edges. It uses the [on](/api/ogma/events.html#ogma-events-on) method to listen to the [click](/api/events.html#event-click) event and displays informations about the clicked element.

## Code

```typescript
import Ogma from '@linkurious/ogma';

const ogma = new Ogma({
  container: 'graph-container'
});

ogma.events.on('click', evt => {
  const target = evt.target,
    button = evt.button, // can be "left", "middle" or "right"
    x = evt.x,
    y = evt.y;

  let clickTarget;
  if (!target) {
    clickTarget = 'background';
  } else {
    clickTarget = (target.isNode ? 'node' : 'edge') + ' ' + target.getId();
  }
  document.getElementById('info')!.textContent =
    clickTarget + ' clicked ' + button + ' at (' + x + ',' + y + ')';
});

ogma.styles.addNodeRule({
  text: {
    content: n => 'Node ' + n.getId()
  }
});

ogma.styles.addEdgeRule({
  text: {
    content: e => 'Edge ' + e.getId()
  }
});

const graph = await ogma.generate.random({ nodes: 5, edges: 10 });
await ogma.setGraph(graph);
await ogma.view.locateGraph();
```

## Tags

interactions

## See Also

- [Live Example](https://doc.linkurio.us/ogma/latest/examples/click.html)
- [API Reference](references/REFERENCE.md)
