# Drag nodes

This example shows how to use the [nodesDragStart](/api/events.html#event-nodesdragstart), [nodesDragProgress](/api/events.html#event-nodesdragprogress) and [nodesDragEnd](/api/events.html#event-nodesdragend) events.<br/>
Uncomment in the handlers to see the effect in your console.

## Code

```typescript
import Ogma from '@linkurious/ogma';

const ogma = new Ogma({
  container: 'graph-container'
});

ogma.events.on('nodesDragStart', eventData => {
  console.log('start', eventData);
  // console.log('Starting drag nodes ' +
  // eventData.nodes.getId().join() +
  // ' at (' + eventData.x + ', ' + eventData.y + ')');
});

ogma.events.on('nodesDragProgress', eventData => {
  console.log('progress', eventData);
  // console.log('Dragging node ' + eventData.node.getId() +
  // ' to (' + eventData.x + ', ' + eventData.y + ')');
});

ogma.events.on('nodesDragEnd', eventData => {
  console.log('end', eventData);
  // console.log('Ending drag node ' + eventData.node.getId() +
  // ' at (' + eventData.x + ', ' + eventData.y + ')');
});

// Generate a random graph and assign it to Ogma.
ogma.generate
  .random({ nodes: 16, edges: 0 })
  .then(graph => ogma.setGraph(graph))
  .then(() => ogma.layouts.grid({ duration: 0, locate: true }));
```

## Tags

integrations

## See Also

- [Live Example](https://doc.linkurio.us/ogma/latest/examples/drag-nodes.html)
- [API Reference](references/REFERENCE.md)
