# Color

This example shows how the [color attribute](/api/types/edgeattributes) can be used to change the color of edges in a graph.

## Code

```typescript
import Ogma from '@linkurious/ogma';

const COLORS = ['#132b43', '#326896', '#54aef3'];

const ogma = new Ogma({
  container: 'graph-container'
});

// Create a rule that assigns a color to each node using a function.
// This function must be deterministic as it will be called later on, each time the node must be redrawn.
ogma.styles.addEdgeRule({
  color: e => COLORS[+e.getId() % COLORS.length],
  width: 5
});

// Generate a random graph
const graph = await ogma.generate.grid({ rows: 3, columns: 3 });
// Assign this graph to Ogma.
await ogma.setGraph(graph);
await ogma.layouts.force({
  duration: 0,
  locate: true,
  charge: 1
});
// Color the edge '0' in orange.
await ogma.getEdge('0')!.setAttributes({ color: 'orange' });

// Assign the edges who have node '13' as source the color 'purple' and an arrow shape.
await ogma
  .getEdges()
  .filter(e => {
    return e.getSource().getId() === '13';
  })
  .setAttributes({
    color: 'purple',
    shape: 'arrow'
  });
```

## Tags

styles

## See Also

- [Live Example](https://doc.linkurio.us/ogma/latest/examples/edge-color.html)
- [API Reference](references/REFERENCE.md)
