# Shape

This example shows how to use the [shape attribute](/api/types/edgeattributes) to change the shape of edges in a graph. It consists of four keys: `head`, `tail`, `body` and `style`.

## Code

```typescript
import Ogma, {
  EdgeStyle,
  EdgeExtremity,
  EdgeType
} from '@linkurious/ogma';
import { random } from './randomize';

const TYPE: EdgeType[] = ['line', 'triangle'];
const STYLE: EdgeStyle[] = ['plain', 'dashed'];
const HEAD: EdgeExtremity[] = [null, 'arrow'];
const TAIL: EdgeExtremity[] = [null, 'arrow'];

const ogma = new Ogma({
  container: 'graph-container'
});

ogma.styles.addEdgeRule({
  shape: {
    body: () => TYPE[(random() * TYPE.length) | 0],
    style: () => STYLE[(random() * STYLE.length) | 0],
    head: () => HEAD[(random() * HEAD.length) | 0],
    tail: () => TAIL[(random() * TAIL.length) | 0]
  }
});

const graph = await ogma.generate.grid({ rows: 4, columns: 4 });
graph.nodes.forEach(node => {
  node.attributes!.radius = 1;
});
graph.edges.push({ source: '5', target: '6' }, { source: '9', target: '10' });
await ogma.setGraph(graph);
```

## Tags

styles

## See Also

- [Live Example](https://doc.linkurio.us/ogma/latest/examples/edge-shape.html)
- [API Reference](references/REFERENCE.md)
