# Width

This example shows how to use the edge [width attribute](/api/types/edgeattributes) to change the width of edges in a graph.

## Code

```typescript
import Ogma, { RawEdge, RawNode } from '@linkurious/ogma';

const ogma = new Ogma({
  container: 'graph-container'
});

// Create a random graph.
const nodes: RawNode[] = [];
const edges: RawEdge[] = [];
const distance = 100;

ogma.styles.addRule({
  nodeAttributes: {
    color: '#1499ff'
  }
});
for (let i = 0; i < 5; i++) {
  nodes.push(
    { id: nodes.length.toString(), attributes: { x: distance * i, y: 0 } },
    {
      id: (nodes.length + 1).toString(),
      attributes: { x: distance * i, y: distance }
    }
  );
  edges.push({
    source: nodes[nodes.length - 2].id!,
    target: nodes[nodes.length - 1].id!,
    attributes: { width: i + 1 }
  });
}
await ogma.setGraph({ nodes, edges });
await ogma.view.locateGraph();
```

## Tags

styles

## See Also

- [Live Example](https://doc.linkurio.us/ogma/latest/examples/edge-size.html)
- [API Reference](references/REFERENCE.md)
