# Add edge

This example shows how to add an edge to the graph using the [addEdge](/api/ogma.html#ogma-addedge) method.

## Code

```typescript
import Ogma from '@linkurious/ogma';

const ogma = new Ogma({
  container: 'graph-container'
});

ogma.addNodes([
  { id: 'n0', attributes: { x: 0, y: 0, color: 'green' } },
  { id: 'n1', attributes: { x: 60, y: 20, color: 'magenta' } },
  { id: 'n2', attributes: { x: 30, y: -30, color: 'orange' } }
]);

ogma.addEdges([
  { id: 'e0', source: 'n0', target: 'n1' },
  { id: 'e1', source: 'n2', target: 'n2' }
]);

setTimeout(() => {
  // Add multiple edges:
  ogma
    .addEdges([
      { id: 'e2', source: 'n1', target: 'n2' },
      { id: 'e3', source: 'n0', target: 'n1' }
    ])
    .then(edges => {
      edges.pulse({ width: 1, duration: 1000, endRatio: 12 });
    });
}, 1000);

ogma.view.locateGraph();
```

## Tags

interactions, graph-drawing

## See Also

- [Live Example](https://doc.linkurio.us/ogma/latest/examples/graph-add-edge.html)
- [API Reference](references/REFERENCE.md)
