# Add node

This example shows how to add a node to the graph using the [addNode](/api/ogma.html#ogma-addnode) method.

## Code

```typescript
import Ogma from '@linkurious/ogma';

const ogma = new Ogma({
  container: 'graph-container'
});

// Add multiple nodes
ogma
  .addNodes([
    { id: 'n1', attributes: { x: -40, y: 20, color: 'magenta' } },
    { id: 'n2', attributes: { x: 0, y: -30, color: 'orange' } },
    { id: 'n3', attributes: { x: 40, y: 20, color: 'orange' } }
  ])
  .then(() => ogma.view.locateGraph());

setTimeout(() => {
  ogma
    .addNode({
      id: 'n0',
      attributes: { x: 0, y: 0, color: 'green', radius: 20 }
    })
    .pulse({ width: 5, duration: 1000 });
}, 1000);
```

## Tags

interactions, graph-drawing

## See Also

- [Live Example](https://doc.linkurio.us/ogma/latest/examples/graph-add-node.html)
- [API Reference](references/REFERENCE.md)
