# Load graph

This example shows how to load a graph using the [Ogma constructor](/api/ogma.html#ogma-constructor).

## Code

```typescript
import Ogma, { RawGraph } from '@linkurious/ogma';
import { random } from './randomize';

// Custom function that generates a graph.
const randomGraph = (N: number, E: number) => {
  const g: RawGraph = { nodes: [], edges: [] };
  for (let i = 0; i < N; i++) {
    g.nodes.push({
      id: 'n' + i,
      attributes: {
        x: random() * 100,
        y: random() * 100,
        text: 'n' + i,
        radius: 5 + 10 * random()
      }
    });
  }
  for (let i = 0; i < E; i++) {
    g.edges.push({
      id: 'e' + i,
      source: 'n' + ((random() * N) | 0),
      target: 'n' + ((random() * N) | 0),
      attributes: { text: 'edge' + i }
    });
  }
  return g;
};
// Generate a random graph with the randomGraph function defined above.
const ogma = new Ogma({
  graph: randomGraph(10, 10), // load the graph at init
  container: 'graph-container'
});

ogma.addEdges([
  { source: 'n0', target: 'n0' },
  { source: 'n0', target: 'n0' }
]);

// Alternatively:
//const ogma = new Ogma({
//  container: 'graph-container'
//});
// ogma.setGraph(g);
//// or:
// ogma.addNodes(g.nodes);
// ogma.addEdges(g.edges);
```

## Tags

parsers

## See Also

- [Live Example](https://doc.linkurio.us/ogma/latest/examples/graph-load.html)
- [API Reference](references/REFERENCE.md)
