# Read nodes and edges

This example shows how to retrieve nodes and edges from your Ogma instance. It uses the [getNodes](/api/ogma.html#ogma-getnodes) and [getEdges](/api/ogma.html#ogma-getedges) methods to retrieve the nodes and edges from the graph.
They return [NodeList](/api/nodelist.html) and [EdgeList](/api/edgelist.html) objects, which are iterable and can be transformed into read-only Arrays.

## Code

```javascript
import Ogma from '@linkurious/ogma';

const ogma = new Ogma({
  container: 'graph-container'
});

// Generate a random Graph.
ogma.generate
  .random({
    nodes: 50,
    edges: 50
  })
  .then(g => {
    // Assign this graph to ogma.
    ogma.setGraph(g);
    ogma.view.locateGraph();

    // METHOD 1 : using NodeList and EdgeList data structures (recommended)
    // nodes
    ogma.getNodes().forEach(node => {
      // do something with the node
      console.log(node.getId());
    });
    // edges
    ogma.getEdges().forEach(edge => {
      // do something with the edge
      console.log(edge.getId());
    });

    // Chaining operations on NodeLists to obtain the list of node ids
    const ids = ogma.getNodes().getId().join();
    console.log('Node ids ', ids);

    // Transforming the NodeList and EdgeList into Arrays (slowest)
    // nodes
    const nodeArray = ogma.getNodes().toArray();
    for (let i = 0; i < nodeArray.length; i++) {
      console.log(nodeArray[i].getId());
    }
    // edges
    const edgeArray = ogma.getEdges().toArray();
    for (let i = 0; i < edgeArray.length; i++) {
      console.log(edgeArray[i].getId());
    }
  });
```

## Tags

parsers

## See Also

- [Live Example](https://doc.linkurio.us/ogma/latest/examples/graph-read.html)
- [API Reference](references/REFERENCE.md)
