# Hover

This example shows how to use the [mouseover](/api/events.html#event-mouseover)
and [mouseout](/api/events.html#event-mouseout) event to display information about the element the mouse is hovering over.

## Code

```typescript
import Ogma from '@linkurious/ogma';

const ogma = new Ogma({
  container: 'graph-container'
});

const info = document.getElementById('info') as HTMLDivElement;

ogma.events
  .on('mouseover', evt => {
    if (evt.target) {
      const { target, x, y } = evt;
      info.innerHTML = `Hovered ${
        target.isNode ? 'node' : 'edge'
      } ${target.getId()} at position (${x}, ${y})`;
    }
  })
  .on('mouseout', evt => {
    if (evt.target) {
      const { target, x, y } = evt;
      info.innerHTML = `Unhovered ${
        target.isNode ? 'node' : 'edge'
      } ${target.getId()} at position (${x}, ${y})`;
    }
  });

ogma.styles.addNodeRule({
  text: {
    content: n => 'Node ' + n.getId()
  }
});

ogma.styles.addEdgeRule({
  text: {
    content: e => 'Edge ' + e.getId()
  }
});

ogma.generate
  .random({ nodes: 5, edges: 10 })
  .then(ogma.setGraph)
  .then(() => ogma.view.locateGraph());
```

## Tags

interactions

## See Also

- [Live Example](https://doc.linkurio.us/ogma/latest/examples/hover.html)
- [API Reference](references/REFERENCE.md)
