# Template Index

Code templates extracted from Ogma examples for common use cases.

## Data Import


## Graph Operations

- [Load graph](./graph-load.md)
- [Read nodes and edges](./graph-read.md)
- [Add node](./graph-add-node.md)
- [Add edge](./graph-add-edge.md)

## Node Styles

- [Radius](./node-size.md)
- [Color](./node-color.md)
- [Text](./node-text.md)
- [Icon](./node-icon.md)

## Edge Styles

- [Width](./edge-size.md)
- [Color](./edge-color.md)
- [Shape](./edge-shape.md)

## Analysis

- [Data-driven styles](./data-driven-styles.md)

## Layouts

- [Force layout](./layout-force.md)
- [Hierarchical](./layout-hierarchical.md)
- [Radial](./layout-radial.md)
- [Grid](./layout-grid.md)

## Interaction

- [Hover](./hover.md)
- [Click](./click.md)
- [Select](./select.md)
- [Drag nodes](./drag-nodes.md)

## Transformations

- [Group nodes](./group-nodes.md)
- [Group edges](./group-edges.md)
- [Visual grouping](./visual-grouping.md)

## Additional Resources

- [SKILL.md](SKILL.md) - Main skill overview and workflows
- [API Reference](references/REFERENCE.md) - Complete API documentation
- [Concepts](concepts/) - Detailed concept guides

## Live Examples

All examples are available at [doc.linkurio.us/ogma/latest/examples/](https://doc.linkurio.us/ogma/latest/examples/)
