# Hierarchical

This example shows how to use the [hierarchical layout](/api/ogma/layouts.html#ogma-layouts-hierarchical) algorithm. The hierarchical layout is a layout algorithm that places the nodes in a hierarchy. It is useful for visualizing trees and DAGs.

## Code

```typescript
import Ogma from '@linkurious/ogma';

const ogma = new Ogma({
  container: 'graph-container'
});

const graph = await ogma.generate.balancedTree({
  children: 2,
  height: 5
});
graph.nodes.forEach(node => {
  node.attributes!.x = 0;
  node.attributes!.y = 0;
});
await ogma.setGraph(graph);

// Run layout
await ogma.layouts.hierarchical({
  direction: 'TB', // Direction of the layout. Can be TB, BT, LR, or RL,
  // where T = top, B = bottom, L = left, and R = right.
  duration: 300, // Duration of the animation
  nodeDistance: 60, // Number of pixels that separate nodes horizontally in the layout.
  levelDistance: 50, // Number of pixels between each layer in the layout.
  locate: {
    easing: 'linear',
    duration: 300
  }
});
```

## Tags

layout, algorithms, hierarchical-layout

## See Also

- [Live Example](https://doc.linkurio.us/ogma/latest/examples/layout-hierarchical.html)
- [API Reference](references/REFERENCE.md)
