# Radial

This example shows how to use the [radial layout](/api/ogma/layouts.html#ogma-layouts-radial).It positions nodes around the selected one based on their graph-theoretical distance (shortest path in the graph, connecting them). If there are subgraphs or nodes not reachable from the central node, they will be pushed outwards, but still placed around the layout in a readable way.

## Code

```typescript
import Ogma, { NodeId } from '@linkurious/ogma';

const ogma = new Ogma({
  container: 'graph-container'
});

const run = (
  centralNodeId: NodeId,
  animate: boolean,
  overlap: boolean,
  randomize: boolean
) => {
  console.time('radial stress');
  ogma.layouts
    .radial({
      centralNode: centralNodeId,
      renderSteps: animate,
      randomize: randomize,
      allowOverlap: overlap,
      maxIterations: 200
    })
    .then(() => {
      console.timeEnd('radial stress');
      ogma.view.locateGraph({
        easing: 'linear',
        duration: 200
      });
    });
};

Ogma.parse
  .gexfFromUrl('karate.gexf')
  .then(g => ogma.setGraph(g))
  .then(() => ogma.view.locateGraph())
  .then(() => {
    document.querySelector('#layout')!.addEventListener('click', evt => {
      evt.preventDefault();
      const form = document.querySelector<HTMLFormElement>('#focus-select')!;
      const focusInput = Array.prototype.filter.call(form['focus'], input => {
        return input.checked;
      })[0];
      const focusNode = focusInput.value;
      // @ts-expect-error
      const animate = form['animate'].checked;
      const overlap = form['overlap'].checked;
      const randomize = form['randomize'].checked;
      run(focusNode, animate, overlap, randomize);
    });
  });
```

## Tags

layout, algorithms, radial-layout

## See Also

- [Live Example](https://doc.linkurio.us/ogma/latest/examples/layout-radial.html)
- [API Reference](references/REFERENCE.md)
