# Color

This example shows how to use the [color attribute](/api/types/nodeattributes.html).
Multiple color formats are available: hexadecimal, RGB(A), and <a href="https://www.w3schools.com/cssref/css_colors.asp"
    target="_blank" rel="noopener">CSS color names</a>.

## Code

```typescript
import Ogma from '@linkurious/ogma';

const COLORS = [
  '#161344',
  '#3f1c4c',
  '#632654',
  '#86315b',
  '#a93c63',
  '#cd476a',
  '#f35371'
];

const ogma = new Ogma({
  container: 'graph-container'
});

// Create a rule that assigns a color to each node using a function.
// This function must be deterministic as it will be called each time the node is painted.
ogma.styles.addNodeRule({
  color: n => COLORS[+n.getId() % COLORS.length]
});

// Generate a random graph
const graph = await ogma.generate.random({ nodes: 20, edges: 0 });
// Assign this graph to Ogma.
await ogma.setGraph(graph);
await ogma.layouts.force({ locate: true, duration: 0, gravity: 0.03 });
// Color the node '0' in orange.
ogma.getNode('0')!.setAttributes({ color: 'orange' });

// Color the nodes who have a coordinate x above 90 in purple.
ogma
  .getNodes()
  .filter(n => n.getAttribute('x') > 90)
  .setAttributes({
    color: 'purple'
  });
```

## Tags

styles

## See Also

- [Live Example](https://doc.linkurio.us/ogma/latest/examples/node-color.html)
- [API Reference](references/REFERENCE.md)
