# Radius

This example shows how to use the [radius](/api/types/nodeattributes.html) attribute to change the size of a node.

## Code

```typescript
import Ogma from '@linkurious/ogma';

const ogma = new Ogma({
  container: 'graph-container'
});

// Specify a random size for each node.
ogma.styles.addNodeRule({
  radius: n => 5 + (+n.getId() % 10)
});

// Generate a random graph.
ogma.generate
  .random({ nodes: 20, edges: 0 })
  // Assign the graph to Ogma.
  .then(graph => ogma.setGraph(graph))
  .then(() => ogma.layouts.force({ locate: true, duration: 0 }))
  .then(() => {
    // Change the size of a single node and its color to purple.
    ogma.getNode('0')!.setAttributes({ radius: 5, color: 'purple' });

    // Change the size of two nodes and their color to orange.
    ogma.getNodes(['1', '2']).setAttributes({ radius: 8, color: 'orange' });
  });
```

## Tags

styles

## See Also

- [Live Example](https://doc.linkurio.us/ogma/latest/examples/node-size.html)
- [API Reference](references/REFERENCE.md)
